/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.EmptyFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;

public abstract class AbstractFluidContainerTransferProvider
extends GenericDataProvider {
    private final Map<class_2960, TransferJson> allTransfers = new HashMap<class_2960, TransferJson>();
    private final String modId;

    public AbstractFluidContainerTransferProvider(FabricDataOutput generator, String modId) {
        super(generator, class_3264.field_14190, "mantle/fluid_transfer", FluidContainerTransferManager.GSON);
        this.modId = modId;
    }

    protected abstract void addTransfers();

    protected void addTransfer(class_2960 id, IFluidContainerTransfer transfer, ConditionJsonProvider ... conditions) {
        TransferJson previous = this.allTransfers.putIfAbsent(id, new TransferJson(transfer, conditions));
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate fluid container transfer " + String.valueOf(id));
        }
    }

    protected void addTransfer(String name, IFluidContainerTransfer transfer, ConditionJsonProvider ... conditions) {
        this.addTransfer(new class_2960(this.modId, name), transfer, conditions);
    }

    protected void addFillEmpty(String prefix, class_1935 item, class_1935 container, class_3611 fluid, class_6862<class_3611> tag, long amount, ConditionJsonProvider ... conditions) {
        this.addTransfer(prefix + "empty", (IFluidContainerTransfer)new EmptyFluidContainerTransfer(class_1856.method_8091((class_1935[])new class_1935[]{item}), ItemOutput.fromItem(container), new FluidStack(fluid, amount)), conditions);
        this.addTransfer(prefix + "fill", (IFluidContainerTransfer)new FillFluidContainerTransfer(class_1856.method_8091((class_1935[])new class_1935[]{container}), ItemOutput.fromItem(item), FluidIngredient.of(tag, amount)), conditions);
    }

    protected void addFillEmptyNBT(String prefix, class_1935 item, class_1935 container, class_3611 fluid, class_6862<class_3611> tag, long amount, ConditionJsonProvider ... conditions) {
        this.addTransfer(prefix + "empty", (IFluidContainerTransfer)new EmptyFluidWithNBTTransfer(class_1856.method_8091((class_1935[])new class_1935[]{item}), ItemOutput.fromItem(container), new FluidStack(fluid, amount)), conditions);
        this.addTransfer(prefix + "fill", (IFluidContainerTransfer)new FillFluidWithNBTTransfer(class_1856.method_8091((class_1935[])new class_1935[]{container}), ItemOutput.fromItem(item), FluidIngredient.of(tag, amount)), conditions);
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.addTransfers();
        ArrayList futures = new ArrayList();
        this.allTransfers.forEach((id, data) -> futures.add(this.saveThing(cache, (class_2960)id, data.toJson())));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private record TransferJson(IFluidContainerTransfer transfer, ConditionJsonProvider[] conditions) {
        private JsonElement toJson() {
            JsonElement element = FluidContainerTransferManager.GSON.toJsonTree((Object)this.transfer, IFluidContainerTransfer.class);
            assert (element.isJsonObject());
            if (this.conditions.length != 0) {
                JsonArray array = new JsonArray();
                for (ConditionJsonProvider condition : this.conditions) {
                    array.add((JsonElement)condition.toJson());
                }
                element.getAsJsonObject().add("fabric:load_conditions", (JsonElement)array);
            }
            return element;
        }
    }
}

